<?php
/* 
 * user_model.php : users table
 */


require_once "../models/db.php";
class user_model extends database {
  
  public function __construct(){       
    
    $this->params = array('id' => '', 
			  'email' => '', 
			  'nickname' =>'' ,
			  'password' => '');
    $this->table = 'users';
    parent::__construct();
    
  }
  
  
  public function find_all($sort){
    return parent::find_all($this->table, $this->params, $sort);
  }
  
  
  public function find_by_id($id){
    return parent::find_by_id('users', $id, $this->params);
  }
  
  public function save($params){
    $ret = false;
    if( $this->validate($params) ){
      unset($params['repeat']);
      if( $this->is_uniq($params) ){
	$params['password'] = sha1($params['password']. "nagano2012");
	if( parent::save('users', $params) ){
	  
	  $ret = true;
	}
      }
    }
    return $ret;
  }
  
  
  public function validate($params){
    $flg =  parent::validate($params);
    if ( $flg ){
      $flg = $this->is_mail($params['email']);
    }
    
    if( $params['password'] != $params['repeat'] ){
      $this->msg['password'] = 'same passwoerd ?';      
    }
    
    return $flg;
  }
  
  public function is_mail($val) {
    if (preg_match("/@/", $val)) {
      return true;
    }else{
      $this->msg['email'] = 'mail format!';
      return false;
    }
  }
  
  public function is_uniq($params){
    
    $flg = true;
    $p     = array('id' => '');
    $where = array('email' => $params['email']);
    $res = $this->find_by('users', $where, $p);
    if( !empty($res)  ){    
      $this->msg['email'] = 'already used!';
      $flg = false;
    }
    $where = array('nickname' => $params['nickname']);
    $res = $this->find_by('users', $where, $p);
    if( !empty($res)  ){    
      $this->msg['nickname'] = 'already used!';
      $flg = false;
    }
    
    return $flg;
  }
  
  
  public function login($params){
    $ret = false;
    
    
    $email = $this->db->real_escape_string($params['email']);
    $passwd = sha1 ($params['password']. "nagano2012");   
    
    $where = array('email' => $email,
		   'password' => $passwd);
    
    $cols = $this->params;
    unset($cols['password']);
    $res = $this->find_by($this->table, $where, $cols);
    
    
    if($res){
      $ret = $res;
    }
    return $ret;
  }
  
  
}


?>
