<?php
/* 
 * temp_model.php : model のテンプレート
 */


require_once "../models/db.php";
class temp_model extends database {
  
  public function __construct(){       
    
    // テーブルのフィールド名を連想配列に登録
    $this->params = array('id' => '', 
			  'column1' => '');
    // テーブル名
    $this->table = 'temps';
    parent::__construct();
    
  }
  
  /*
   * find_all($sort)
   *	$sort	並べ替えキー(複数ある時は 「,」でつないだもの)
   *	return: 検索結果, なかった場合はnull
   *  database クラスの find_allを table指定でオーバーライド 
   */
  public function find_all($sort){
    return parent::find_all($this->table, $this->params, $sort);
  }
  
  
  public function find_by_id($id){
    return parent::find_by_id('temps', $id, $this->params);
  }
  
  
  /*
   * save( $params) 新規挿入
   *	$params  データ(連想配列(key→column, value→value)
   *	return: true/false
   */
  public function save($params){
    $ret = false;
    // このvalidateはemptyのチェックだけ あとは自分で実装
    if( $this->validate($params) ){
      if( parent::save('temps', $params) ){
	$ret = true;
      }
    }
    return $ret;
  }
  
  
  /*
   * delete(id)   データの更新用関数
   *	$id      ID
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  function delete($id){
    return parent::delete('temps', $id);
  }
  
}


?>