<?php
/* 
 * list_model.php : liset model
 */


require_once "../models/db.php";
class list_model extends database {
  
  public function __construct(){       
    
    // テーブルのフィールド名を連想配列に登録
    $this->params = array('id' => '', 
			  'user_id' => '',
			  'comment' => '',
			  'created_at'=> '');
    // テーブル名
    $this->table = 'lists';
    parent::__construct();
    
  }
  
  /*
   * find_all($sort)
   *	$sort	並べ替えキー(複数ある時は 「,」でつないだもの)
   *	return: 検索結果, なかった場合はnull
   *  database クラスの find_allを table指定でオーバーライド 
   */
  public  function find_all($sort){
    return parent::find_all($this->table, $this->params, $sort);
  }
  
  
  public function find_by_id($id){
    return parent::find_by_id('lists', $id, $this->params);
  }
  
  
  /*
   * save( $params) 新規挿入
   *	$params  データ(連想配列(key→column, value→value)
   *	return: true/false
   */
  public function save($params){
    $ret = false;
    
    unset($params['id']);
    unset($params['created_at']);
    
    if( $this->validate($params) ){
      if( parent::save('lists', $params) ){
	$ret = true;
      }
    }
    return $ret;
  }
  
  
  /*
   * delete(id)   データの更新用関数
   *	$id      ID
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  function delete($id){
    return parent::delete('lists', $id);
  }
  
}


?>