<?php
/* 
 *  db.php : database class用ファイル
 *  Time-stamp: <Fri Oct 12 18:18:43 JST 2012>  
 */


class database{
  
  protected $db;
  protected $params;
  protected $aparams;
  protected $msg;
  protected $table;
  
  /*  
   *  databaseクラスのコンストラクタ
   */
  public function database(){
    $host     = "127.0.0.1";
    $user     = "gorinuser";
    $passwd   = "gorinpasswd";
    $dbname   = "nagano2012";
    $this->db = new mysqli($host, $user, $passwd);
    if(!$this->db){
      die('データベース接続失敗'.$this->db->error());
      exit;
    }
    /* 文字セットを utf8 に変更します */
    if (!$this->db->set_charset("utf8")) {
      die('文字コード指定失敗'.$this->db->error());
    }
    if(! $db_selected = $this->db->select_db( $dbname) ){
      die('データベース選択失敗'.$this->db->error());
    }
    foreach ($this->params as $key => $value){
      $this->msg[$key]  = null;
    }
    unset($this->msg['id'] );
  }
  
  
  /*
   * save($table, $params) 新規挿入
   *	$table   テーブル名       
   *	$params  データ(連想配列(key→column, value→value)
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  public function save($table, $params){
    // サニタイズ
    $table = $this->db->real_escape_string($table);
    // SQL生成 & サニタイズ
    $line0 ="";
    $line1 ="";
    unset($params['id']);
    foreach ($params as $key => $value){
      $line0 = $line0 . $this->db->real_escape_string($key) . ",";
      $line1 = $line1 . "'".$this->db->real_escape_string($value) . "',";
    }
    $line0 = trim(trim($line0), ',');
    $line1 = trim(trim($line1), ',');
    
    $sql = "INSERT INTO ". $table . 
      "(" .$line0 .") VALUES (" . $line1 . ")";
    
    $res = $this->db->query($sql);
    $ret = $this->db->insert_id;
    return $ret;
    
  }
  /*
   * update($table, $params)   データの更新用関数
   *	$table   テーブル名       
   *	$params  データ(連想配列(key→column, value→value)
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  public function update($table, $params){
    // サニタイズ
    $id    = $this->db->real_escape_string($params['id']);
    $table = $this->db->real_escape_string($table);
    
    unset($params['id']);
    $line0 = ""; 
    foreach ($params as $key => $value){
      $line0 = $line0 . $this->db->real_escape_string($key) . "='" .
	$this->db->real_escape_string($value) . "'," ;
    }
    $line0 = rtrim($line0, ",");
    $sql = "UPDATE $table SET $line0 WHERE id = $id";
    return $this->db->query($sql);
  }
  
  /*
   * delete($table, $id)   データの更新用関数
   *	$table   テーブル名       
   *	$id      ID
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  public function delete($table, $id){
    // サニタイズ
    $id    = $this->db->real_escape_string($id);
    $table = $this->db->real_escape_string($table);
    
    $sql = "DELETE FROM $table WHERE id = $id";
    return $this->db->query($sql);
  }
  
  /*
   * find_by($table, $where, $params)//
   *	$table   テーブル名       
   *	$where  
   *	$params  検索対象(連想配列のキー)
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  public function find_by($table, $where, $params){
    // サニタイズ
    $table = $this->db->real_escape_string($table);
    
    $w = "";
    if(is_array($where)){
      foreach($where as $key => $value){
	$wand = empty($w) ? "WHERE " : " AND ";
	$w = $w . $wand . $this->db->real_escape_string($key) 
	  . "= '" . $this->db->real_escape_string($value). "'" ;
      }
    }
    
    $line0 = $this->selectline($params);
    $sql = "SELECT $line0 FROM $table $w";
    $res = $this->db->query($sql);
    
    
    $ret = false;
    while($row = $res->fetch_array()){
      
      foreach($params as $key => $value){
	$ret[$key] = $row[$key];
      }
    }
    return $ret;
  }
  
  
  /*
   * find_by_id($table, $id, $params)//  idによる検索
   *	$table   テーブル名       
   *	$id      検索するid
   *	$params  検索対象(連想配列のキー)
   *	return: 検索結果の連想配列, なかった場合はnull
   */
  public function find_by_id($table, $id, $params){
    return $this->find_by($table, array('id' => $id), $params);
  }
  
  /*
   * find_all($table, $params, $sort)
   *	$table	テーブル
   *	$params  検索対象(連想配列のキー)
   *	$sort	並べ替えキー(複数ある時は 「,」でつないだもの)
   *	return: 検索結果, なかった場合はnull
   */
  public function find_all($table, $params, $sort){
    $ret = null;
    $table = $this->db->real_escape_string($table);
    $sort  = $this->db->real_escape_string($sort);
    $line = $this->selectline($params);
    $sql = "SELECT $line FROM $table ORDER BY $sort";
    
    $res = $this->find_by_sql($sql);
    $n=0;
    while($row = $res->fetch_array()){
      foreach($params as $key => $value){
	$ret[$n][$key] = $row[$key];
      }
      $n++;
    }
    
    return $ret;
    
    
  }
  /*
   * find_by_sql($sql)
   *	$sql     SQL文 ただしサニタイズ済みであること!
   *	return: 検索結果, なかった場合はnull
   */
  public function find_by_sql($sql){
    
    $res = $this->db->query($sql);
    
    return $res;
    
  }
  
  /*
   * find_all_by($table, $where, $params, $sort)
   *	$table   テーブル名       
   *	$where   検索キー(連想配列 key='value')
   *	$params  検索対象(連想配列のキー)
   *	$sort	並べ替えキー(複数ある時は 「,」でつないだもの)
   *	return: 検索結果, なかった場合はnull
   */
  public function find_all_by($table, $where, $params, $sort){
    // サニタイズ
    $table = $this->db->real_escape_string($table);
    $sort  = $this->db->real_escape_string($sort);
    
    $line0 = $this->selectline($params);
    $w = "";
    foreach($where as $key => $value){
      $wand = empty($w) ? "WHERE " : " AND ";
      $w = $wand . $this->db->real_escape_string($key) 
	. "= '" . $this->db->real_escape_string($value). "'" ;
    }
    $sql = "SELECT $line0 FROM $table $w ORDER BY $sort";
    
    $res = $this->find_by_sql($sql);
    
    $n=0;
    $ret = null;
    if($res){
      while($row = $res->fetch_array()){
	foreach($params as $key => $value){
	  $ret[$n][$key] = $row[$key];
	}
	$n++;
      }
    }
    
    return $ret;
  }
  
  /*
   *
   */
  public function selectline($params){
    
    if(isset($params['id'])){
      unset($params['id']);
    }
    $line0 = "id "; 
    foreach ($params as $key => $value){
      $line0 = $line0 . ", " . $this->db->real_escape_string($key) ;
    }
    return $line0;
  }
  
  
  /*
   * result2array($res)
   *	$res	検索結果
   *	return: 配列
   */
  public function result2array($res, $col){
    $ret[] = '';
    while($row = $this->db->fetch_array($res)){
      $ret[] = $row[$col];
    }
    unset($ret[0]);
    return $ret;
  }
  
  public function validate($params){
    $flg = true;
    
    foreach ($params as $key => $value){
      if( empty($params[$key]) ){
	$this->msg[$key] = "empty!";
	$flg =false;
      }
    }
    return $flg;
  }
  
  public function paramsclear(){
    foreach($this->params as $key => $value){
      $this->params[$key] = '';
    }
  }
  
  public function getparams(){
    return $this->params;
  }
  
}

?>