<?php
/*
 * main_controller.php : mainコントローラクラス
 */

class main_controller{
  
  protected $page;
  protected $dir;
  protected $user;
  protected  $login;
  
  
  public function __construct($flg = null){
    session_set_cookie_params(0, '/');
    session_start();
    
    $this->user = array('id' => '');
    $this->login = false;
    
    
    if(isset($_SESSION['nagano'])){
      $this->user  = $_SESSION['nagano'];
      $this->login = true; 
      $this->dir = "main";
      $this->page = "index";
      
    }else{
      $this->dir = "auth";
      $this->page = "login";
      if($flg == null){
	$this->showpage();
	exit;
      }
    }
  }
  
  
  /* 
   * gparams($params): GETパラメータの取得
   * $params         : パラメータのハッシュ
   */
  public function gparams($params){
    foreach($params as $key => $value){
      $params[$key] = isset($_GET[$key]) ? $_GET[$key] : $value;
    }
    return $params;
  }
  
  
  /* 
   * pparams($params): POSTパラメータの取得
   * $params         : パラメータのハッシュ
   */
  public function pparams($params){
    foreach($params as $key => $value){
      $params[$key] = isset($_POST[$key]) ? $_POST[$key] : $value;
    }
    return $params;
  }
  
  public function getaction(){
    $val = array('action' => 'default');
    $ret = $this->gparams($val);
    
    return $ret['action'];
    
  }
  public  function showpage(){
    $show = "../views/". $this->dir . "/".  $this->page . ".php";
    if ( file_exists($show) ){
      require $show;
    }else{
      $this->redirect_to("./error.html");
    }
  }
  
  
  
  public function redirect_to($uri){
    $uri = htmlspecialchars($uri);
    header("Location: $uri");
  }
  
  public function h($str){
    print htmlspecialchars($str);
  }
  
  public function h_nl2br($str){
    print nl2br(htmlspecialchars($str));
  }
  
  public function getuser(){
    return $this->user;
  }
}


?>