<?php
/* 
 * list_controller.php : list controller
 */

require_once "../controllers/main_controller.php"; 
require_once "../models/list_model.php"; 

class list_controller extends main_controller{
  
  private $list;
  public $view;
  public function __construct(){
    parent::__construct();
    
    // viewファイルの初期設定
    $this->dir = "list";     // views/list/ の下の
    $this->page = "index";   // index.php 
    
    // db
    $this->list = new list_model();
    // action の取得
    $action = $this->getaction();
    
    // action による振り分け
    switch($action){
    case "create":
      $this->createaction();
      break;
    case "destroy":
      $this->destroyaction();
      break;
      
    default:
      $this->indexaction();
    }
    
    
    
  }
  
  // index
  public function indexaction(){
    $this->view = $this->list->find_all('created_at desc');
  }
  
  // 登録
  public function createaction(){
    $params = $this->pparams($this->list->getparams());
    $params['user_id'] = $this->user['id'];
    $this->list->save($params);
    $this->redirect_to("?controller=list");
  }
  
  // 削除
  public function destroyaction(){
    $params = $this->gparams(array('id' => ''));
    $this->list->delete($params['id']);
    $this->redirect_to("?controller=list");
  }
  
}


?>